#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "GlobalDefines.h"
#include "Canvas.h"
#include "Circuit.h"

class MainWindow : public QMainWindow
{
        Q_OBJECT
    public:
        MainWindow(QWidget *parent = 0);
        ~MainWindow();

    signals:
        void zoomCanvas(int);

    private slots:
        void updateZoomValue(int);
        void updateStatus(QString status);
        void loadCircuit(void);
        void showHelp(void);

    private:
        void createActions(void);
        void createMenus(void);

        Canvas *canvas;
        QSlider *zoomSlider;
        QLabel *zoomValue;

        Circuit *circuit;

        QMenu *fileMenu;
        QMenu *helpMenu;
        QMenu *circuitMenu;
        QAction *loadCircuitFileAction;
        QAction *showHelpAction;
        QAction *resetCircuitAction;
        QAction *showSimControllerAction;
        QAction *toggleWireValuesAction;

};

#endif // MAINWINDOW_H
